function estIntegral = integralSimpsons(f, a, b)
% Numerical integration using Simpson's rule.
%
% INPUTS:
%       f - The function handle.
%       a - Lower limit.
%       b - Upper limit.
%
% OUTPUT:
%       Int - The numerical estimate of the integral.

c = (a + b)/2;
h = b - a;

estIntegral = (h/6)*(f(a) + 4*f(c) + f(b));

end

